Attribute VB_Name = "modGlbl"
' (32-bit version)

Option Explicit

Global gsCurrDir As String   ' Current working directory
Global gsInitFile As String  ' Initialization File
Global gsInitSect As String  ' Initialization Section
Global gsInitDrv As String   ' Initialization file disk drive

Global gbAutoSync As Boolean  ' Automatically Synchronize?
Global gbNtfyUser As Boolean  ' Ask and Notify the User about copies and deletions?
Global gsRunDir As String     ' Working Directory for Run Command
Global gsRunCmd As String     ' Run Command string
Global gbSyncBoth As Boolean  ' Run synchronization in both directions?
Global gbCopyOld As Boolean   ' Copy older source files?
Global gbDelXtra As Boolean   ' Delete extra target files?

Global gsLog As String  ' Activity log report string

Global gsCRLF As String  ' Carriage Return, Line Feed
Global gsLF As String    ' Line Feed


Declare Function GetPrivateProfileString Lib "kernel32" _
          Alias "GetPrivateProfileStringA" _
          (ByVal lpApplicationName As String, _
           lpKeyName As Any, _
           ByVal lpDefault As String, _
           ByVal lpReturnedString As String, _
           ByVal nSize As Long, _
           ByVal lpFileName As String) As Long

Function bFileExists(ByVal vsFileName As String) As Boolean
    Dim sTime As String

    On Error Resume Next  ' See if file exists
        sTime = FileDateTime(vsFileName)
        If Err.Number = 0 Then
            bFileExists = True
        Else
            bFileExists = False
        End If
    On Error GoTo 0
End Function

Sub ExecuteRunCommand()
    Dim hInsc As Long  ' Handle to program instance
    Dim sDrv As String

    If gsRunCmd <> "" Then
        On Error Resume Next
            If gsRunDir <> "" Then  ' Set working directory
                If InStr(gsRunDir, ":") > 0 Then
                    sDrv = Left$(gsRunDir, 1)
                    ChDrive (sDrv)
                End If
                ChDir (gsRunDir)
            End If

            hInsc = Shell(gsRunCmd, 1) ' Run program normally
            If Err.Number <> 0 Then
                Beep
                MsgBox "Could not execute command:" & gsLF & gsRunCmd & gsLF & Err.Description, vbInformation, "Directory Synchronization Utility"
            End If
        On Error GoTo 0
    End If
End Sub

Sub InitializeLogText()
    Dim dCurrTime  ' Variant (date)

    dCurrTime = Now
    gsLog = "Directory Synchronization Utility run on " & Format(dCurrTime, "d-mmm-yyyy") & " at " & Format(dCurrTime, "h:nnam/pm")
End Sub

Sub Main()
    Dim sCmd As String
    Dim i As Long

    gsCRLF = Chr$(13) & Chr$(10)  ' Pseudo constant (carriage-return, line-feed)
    gsLF = Chr$(10)

    gsCurrDir = CurDir$
    If Right$(gsCurrDir, 1) <> "\" Then
        gsCurrDir = gsCurrDir & "\"
    End If

    sCmd = Trim$(Command$)  ' Command line argument(s)
    i = InStr(sCmd, " ") ' InitFile InitSect
    If i = 0 Then
        gsInitFile = sCmd
        gsInitSect = "SyncDir"  ' Default name
    Else
        gsInitFile = Left$(sCmd, (i - 1))
        gsInitSect = Trim$(Mid$(sCmd, (i + 1)))  ' Rest of string
    End If

    If gsInitFile = "" Then
        gsInitFile = gsCurrDir & "SyncDir.ini"
        If Not bFileExists(gsInitFile) Then
            gsInitFile = ""
        End If
    Else
        If (InStr(gsInitFile, ":") = 0) _
        And (InStr(gsInitFile, "\") = 0) Then  ' Supply directory path
            gsInitFile = gsCurrDir & gsInitFile
        End If
        
        If Not bFileExists(gsInitFile) Then
            Beep
            MsgBox "Could not open initialization file " & UCase$(gsInitFile), vbInformation, "Directory Synchronization Utility"
            gsInitFile = ""
        End If
    End If
    
    gsInitDrv = Left$(gsCurrDir, 2)
    If InStr(gsInitFile, ":") = 2 Then
        gsInitDrv = Left$(gsInitFile, 2)
    End If

    gbAutoSync = False
    gbNtfyUser = True
    gbCopyOld = False
    gbDelXtra = False

    Load frmMain  ' Will finish reading initialization file
End Sub

Function nSynchronizeDirectories(ByVal vbCopyOld As Boolean, ByVal vbDelXtra As Boolean, ByVal vsSrcDir As String, ByVal vsTrgtDir As String, ByVal vsIgnrType As String) As Long
    Dim nCopy As Long        ' # files copied
    Dim nDel As Long         ' # files deleted
    Dim sMsg As String       ' MsgBox message string
    Dim uRslt As Long        ' MsgBox result code
    Dim bSync As Boolean     ' User chose to synchronize?
    Dim sIgnrType As String  ' File types (extensions) to ignore

    bSync = True

    sIgnrType = UCase$(vsIgnrType)
    If sIgnrType <> "" Then
        sIgnrType = "," & sIgnrType & ","  ' Allow searches for ",XXX," file type
    End If

    ' Make a pass, without actually synchronizing
    Call SynchronizeFiles(False, vbCopyOld, vbDelXtra, vsSrcDir, vsTrgtDir, sIgnrType, nCopy, nDel)
    If (nCopy > 0) Or (nDel > 0) Then
        sMsg = "In order to synchronize target directory """ & vsTrgtDir & """ with source directory """ & vsSrcDir & """, " & LTrim$(Str$(nCopy)) & " file(s) will be copied"
        If nDel > 0 Then
            sMsg = sMsg & " and " & LTrim$(Str$(nDel)) & " file(s) will be deleted"
        End If
        sMsg = sMsg & "."

        If gbAutoSync And (Not gbNtfyUser) Then
            uRslt = vbOK
        Else
            uRslt = MsgBox(sMsg, (vbQuestion + vbOKCancel), "Directory Synchronization Utility")
        End If
        If uRslt = vbOK Then
            DoEvents  ' Allow forms refresh
            ' Make a second pass, actually synchronizing this time
            Call SynchronizeFiles(True, vbCopyOld, vbDelXtra, vsSrcDir, vsTrgtDir, sIgnrType, nCopy, nDel)
        Else
            bSync = False
        End If
    End If
    
    nSynchronizeDirectories = nCopy + nDel
    
    If nSynchronizeDirectories < 0 Then
        MsgBox "Directory """ & vsTrgtDir & """ can not be synchronized with directory """ & vsSrcDir & """", vbInformation, "Directory Synchronization Utility"
    ElseIf Not bSync Then
        nSynchronizeDirectories = 0
    ElseIf (Not gbAutoSync) And (nCopy = 0) And (nDel = 0) Then
        MsgBox "Directory """ & vsTrgtDir & """ already matched directory """ & vsSrcDir & """", vbInformation, "Directory Synchronization Utility"
    End If
End Function

Function sInitializationEntry(ByVal vsName As String, ByVal vsDflt As String) As String
    Dim sBuff As String   ' Character buffer for Windows API function call
    Dim nBuffLen As Long  ' Buffer length returned by Windows API function

    If gsInitFile = "" Then
        sInitializationEntry = vsDflt
    Else
        sBuff = Space$(255)  ' Pre-allocate the buffer
        nBuffLen = GetPrivateProfileString( _
                gsInitSect, ByVal vsName, vsDflt, _
                sBuff, Len(sBuff), gsInitFile)
        sInitializationEntry = UCase$(Left$(sBuff, nBuffLen))
    End If
End Function

Sub SynchronizeFiles(ByVal vbExec As Boolean, ByVal vbCopyOld As Boolean, ByVal vbDelXtra As Boolean, ByVal vsSrcDir As String, ByVal vsTrgtDir As String, ByVal vsIgnrType As String, rnCopy As Long, rnDel As Long)
    Dim sSrc As String   ' Local copy of Source directory name
    Dim sTrgt As String  ' Local copy of Target directory name
    Dim sFile As String  ' Current filename
    Dim sType As String  ' Current file's type (extension)
    Dim sSrcTime As String   ' Source file timestamp
    Dim sTrgtTime As String  ' Target file timestamp
    Dim bErr As Boolean  ' Error in processing
    Dim bCncl As Boolean  ' User requested Cancel
    Dim uRslt As Long
    Dim s As String

    bErr = False
    bCncl = False
    
    Screen.MousePointer = 11  ' Hourglass
    sSrc = vsSrcDir
    If Right$(sSrc, 1) <> "\" Then
        sSrc = sSrc & "\"
    End If

    sTrgt = vsTrgtDir
    If Right$(sTrgt, 1) <> "\" Then
        sTrgt = sTrgt & "\"
    End If

    rnCopy = 0
    rnDel = 0
    
    If vbExec Then  ' This is the actual execution pass
        gsLog = gsLog & gsCRLF & gsCRLF & "Synchronizing files:" & gsCRLF & "  Source: """ & sSrc & "*.*""" & gsCRLF & "  Target:  """ & sTrgt & "*.*"""
        
        If vbCopyOld Then
            gsLog = gsLog & gsCRLF & gsCRLF & "Copying different source files ..."
        Else
            gsLog = gsLog & gsCRLF & gsCRLF & "Copying newer source files ..."
        End If
    End If

    On Error Resume Next
        s = Dir$(sTrgt, vbDirectory)  ' Should return "." directory entry
        If (s = "") Or (Err.Number <> 0) Then
            Beep
            MsgBox "Not a valid target directory: """ & sTrgt & """", vbExclamation, "Directory Synchronization Utility"
            bErr = True
        End If
    On Error GoTo 0

    On Error Resume Next
        sFile = Dir$(sSrc & "*.*")  ' This also primes the While loop call to Dir$
        If Err.Number <> 0 Then
            Beep
            MsgBox "Not a valid source directory: """ & sSrc & """", vbExclamation, "Directory Synchronization Utility"
            bErr = True
        End If
    On Error GoTo 0
    
    While (Not bErr) And (Not bCncl) And (sFile <> "")
        sType = UCase$(Mid$(sFile, (1 + InStr(sFile, "."))))  ' Get file type (without ".")
        If (vsIgnrType <> "") And (InStr(vsIgnrType, ("," & sType & ",")) > 0) Then
            If vbExec Then
                gsLog = gsLog & gsCRLF & "  (Ignored file """ & sFile & """)"
            End If
        Else
            sSrcTime = Format(FileDateTime(sSrc & sFile), "yyyymmdd.hhnnss")
    
            On Error Resume Next
                sTrgtTime = Format(FileDateTime(sTrgt & sFile), "yyyymmdd.hhnnss")
                If Err.Number <> 0 Then
                    sTrgtTime = ""
                End If
            On Error GoTo 0
            
            If vbCopyOld And (sSrcTime = sTrgtTime) Then
                If vbExec Then
                    gsLog = gsLog & gsCRLF & "  (""" & sFile & """ matched the source file)"
                End If
            ElseIf (Not vbCopyOld) And (sSrcTime <= sTrgtTime) Then
                If vbExec Then
                    gsLog = gsLog & gsCRLF & "  (""" & sFile & """ was up to date)"
                End If
            Else
                rnCopy = rnCopy + 1
                If vbExec Then
                    On Error Resume Next
                        FileCopy (sSrc & sFile), (sTrgt & sFile)
                        If Err.Number = 0 Then
                            gsLog = gsLog & gsCRLF & "  Copied file """ & sFile & """"
                        Else
                            Beep
                            uRslt = MsgBox(Err.Description, (vbExclamation + vbOKCancel), ("Error copying file """ & sFile & """"))
                            gsLog = gsLog & gsCRLF & "  *** Error copying file """ & sFile & """" & gsCRLF & "      " & Err.Description
                            If uRslt = vbCancel Then
                                bCncl = True
                                gsLog = gsLog & gsCRLF & "*** Directory synchronization cancelled at user request"
                            End If
                        End If
                    On Error GoTo 0
                End If
            End If  ' Else copied file
        End If ' Else not ignoring file
        
        sFile = Dir$  ' Get next matching file

        DoEvents  ' Be a good Windows citizen
        Screen.MousePointer = 11  ' Hourglass
    Wend
    
    If (Not bErr) And (Not bCncl) And vbDelXtra Then
        If vbExec Then
            gsLog = gsLog & gsCRLF & gsCRLF & "Deleting extra target files ..."
        End If

        On Error Resume Next
            sFile = Dir$(sTrgt & "*.*")
            If Err.Number <> 0 Then
                Beep
                MsgBox "Not a valid target directory: """ & sTrgt & """", vbExclamation, "Directory Synchronization Utility"
                bErr = True
            End If
        On Error GoTo 0
        
        While (Not bErr) And (Not bCncl) And (sFile <> "")
            sType = UCase$(Mid$(sFile, (1 + InStr(sFile, "."))))  ' Get file type (without ".")
            If (vsIgnrType <> "") And (InStr(vsIgnrType, ("," & sType & ",")) > 0) Then
                If vbExec Then
                    gsLog = gsLog & gsCRLF & "  (Ignored extra file """ & sFile & """)"
                End If
            Else
                sTrgtTime = Format(FileDateTime(sTrgt & sFile), "yyyymmdd.hhnnss")
        
                On Error Resume Next
                    sSrcTime = Format(FileDateTime(sSrc & sFile), "yyyymmdd.hhnnss")
                    If Err.Number <> 0 Then
                        sSrcTime = ""
                    End If
                On Error GoTo 0
                
                If sSrcTime = "" Then
                    rnDel = rnDel + 1
                    If vbExec Then
                        On Error Resume Next
                            Kill (sTrgt & sFile)
                            If Err.Number = 0 Then
                                gsLog = gsLog & gsCRLF & "  Deleted file """ & sFile & """"
                            Else
                                Beep
                                uRslt = MsgBox(Err.Description, (vbExclamation + vbOKCancel), ("Error deleting file """ & sFile & """"))
                                gsLog = gsLog & gsCRLF & "  *** Error deleting file """ & sTrgt & sFile & """" & gsCRLF & "      " & Err.Description
                                If uRslt = vbCancel Then
                                    bCncl = True
                                    gsLog = gsLog & gsCRLF & "*** Directory synchronization cancelled at user request"
                                End If
                            End If
                        On Error GoTo 0
                    End If
                End If
            End If  ' Else not an ignored file type
            
            sFile = Dir$  ' Get next matching file
        Wend
    End If

    Screen.MousePointer = 0

    If bErr Then
        rnCopy = -1
        rnDel = -1
    End If
End Sub

